package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaRelationNode extends KeyPairMetaObject {

	private MetaLineCollection linecollection = null;
	
	public static final String TAG_NAME = "Node";

	/** 节点的编号 */
	private Integer id = -1;
	/** 节点的描述 */
	private String caption = "";
	/** 节点的数据对象 */
	private String dataobjectkey = "";
	/** 引用的外部定义的KEY */
	private String relationkey = "";
	/** 横坐标 */
	private Integer x = -1;
	/** 纵坐标 */
	private Integer y = -1;

	public void setX(Integer x) {
		this.x = x;
	}

	public Integer getX() {
		return x;
	}

	public void setY(Integer y) {
		this.y = y;
	}

	public Integer getY() {
		return y;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getCaption() {
		return caption;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public Integer getId() {
		return id;
	}

	public void setDataobjectkey(String dataobjectkey) {
		this.dataobjectkey = dataobjectkey;
	}

	public String getDataobjectkey() {
		return dataobjectkey;
	}

	public void setRelationkey(String relationkey) {
		this.relationkey = relationkey;
	}

	public String getRelationkey() {
		return relationkey;
	}
	
	public void setLinecollection(MetaLineCollection linecollection) {
		this.linecollection = linecollection;
	}
	
	public MetaLineCollection getLinecollection() {
		return linecollection;
	}
	
	@Override
	public String getKey() {
		return id.toString();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(linecollection != null){
			list.add(linecollection);
		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaobject = null;
		if (MetaLineCollection.TAG_NAME.equals(tagName)) {
			linecollection = new MetaLineCollection();
			resultMetaobject = linecollection;
		}
		return resultMetaobject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRelationNode newObj = (MetaRelationNode)newInstance();
		newObj.setLinecollection(linecollection == null ? null : (MetaLineCollection)linecollection.clone());
		newObj.setId(id);
		newObj.setCaption(caption);
		newObj.setDataobjectkey(dataobjectkey);
		newObj.setRelationkey(relationkey);
		newObj.setX(x);
		newObj.setY(y);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationNode();
	}

}
