package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMNoKeyCollection;

public class MetaQueryParameterCollection extends AbstractBPMNoKeyCollection<MetaQueryParameter> {
	public final static String TAG_NAME = "QueryParameterCollection";

	@Override
	protected MetaQueryParameter createChildMetaElement(String tagName) {
		MetaQueryParameter child = null;
		if (tagName.equalsIgnoreCase(MetaQueryParameter.TAG_NAME)) {
			child = new MetaQueryParameter();
		}
		return child;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQueryParameterCollection();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray queryParameterArray = new JSONArray();
		Iterator<MetaQueryParameter> it = this.elementArray.iterator();
		MetaQueryParameter metaQueryParameter = null;
		while (it.hasNext()) {
			metaQueryParameter = it.next();
			queryParameterArray.put(metaQueryParameter.toJSON());
		}
		obj.put("queryparameteritems", queryParameterArray);

		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if (json.has("queryparameteritems")) {
			JSONArray queryParameterArray = json.getJSONArray("queryparameteritems");
			for (int i = 0, size = queryParameterArray.length(); i < size; ++i) {
				JSONObject queryParameterObj = queryParameterArray.getJSONObject(i);
				MetaQueryParameter metaQueryParameter = new MetaQueryParameter();
				metaQueryParameter.fromJSON(queryParameterObj);
				this.add(metaQueryParameter);
			}
		}
	}

}
