package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaNodeGraphic extends AbstractMetaObject {

	public final static String TAG_NAME = "NodeGraphic";

	/** 节点的X轴坐标 */
	private Integer x = 0;

	/** 节点的轴坐标 */
	private Integer y = 0;

	/** 节点的宽度 */
	private Integer width = 0;

	/** 节点的高度 */
	private Integer height = 0;
	
	/** 节点使用图片显示  */
	private String image = "";
	
	private String lastImage = "";
	
	private String pastImage = "";
	
	//节点样式属性
	private String style = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNodeGraphic newGraphic = (MetaNodeGraphic) newInstance();
		newGraphic.setX(x);
		newGraphic.setY(y);
		newGraphic.setHeight(height);
		newGraphic.setWidth(width);
		newGraphic.setImage(image);
		newGraphic.setPastImage(pastImage);
		newGraphic.setLastImage(lastImage);
		newGraphic.setStyle(style);
		return newGraphic;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNodeGraphic();
	}

	public Integer getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public Integer getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public Integer getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public Integer getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}
	
	public void setImage(String image) {
		this.image = image;
	}
	
	public String getImage() {
		return this.image;
	}
	
	public void setPastImage(String pastImage) {
		this.pastImage = pastImage;
	}
	
	public String getPastImage() {
		return this.pastImage;
	}
	
	public void setLastImage(String lastImage) {
		this.lastImage = lastImage;
	}
	
	public String getLastImage() {
		return this.lastImage;
	}
	
	public void setStyle(String style) {
		this.style = style;
	}
	
	public String getStyle() {
		return style;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("x", x);
		obj.put("y", y);
		obj.put("width", width);
		obj.put("height", height);
		obj.put("image", image);
		obj.put("image_past", pastImage);
		obj.put("image_last", lastImage);
		obj.put("style", style);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		this.x = json.optInt("x");
		this.y = json.optInt("y");
		this.width = json.optInt("width");
		this.height = json.optInt("height");
		this.image = json.optString("image");
		this.pastImage = json.optString("image_past");
		this.lastImage = json.optString("image_last");
		this.style = json.optString("style");
	}
}
