package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaOperation定义流程节点中的操作
 * 
 * @author 刘翔翔
 *
 */
public class MetaBPMOperation extends KeyPairMetaObject {

	public final static String TAG_NAME = "Operation";
	
	public final static String BATCH_TAG_NAME = "BatchOperation";
	
	/** 操作的标识 */
	private String key = "";
	/** 操作的显示内容 */
	private String caption = "";
	/** 操作的事件 */
	private MetaBaseScript action = null;
	/** 可用条件 */
	private String enable ="ReadOnly()";
	/** 可见条件 */
	private String visible = "";
	/** 图标 */
	private String icon = "";
	/** 模板标识 */
	private String templateKey = "";
	/** 自定义样式*/
	private String cssClass = "";
	
	/*无须保存*/
	private  String customKey = "";
	/** 记录当前语种下的caption */
	private String i18nCaption = "";
	
	/**
	 * 取得操作显示文本
	 * 
	 * @return 显示文本
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置操作的显示文本
	 * 
	 * @param caption
	 *            显示文本
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 获取样式
	 * @return
	 */
	public String getCssClass() {
		return cssClass;
	}

	/**
	 * 设置样式
	 * @param style
	 */
	public void setCssClass(String cssClass) {
		this.cssClass = cssClass;
	}

	/**
	 * 设置事件
	 * 
	 * @param action
	 *            事件
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}

	/**
	 * 取得事件
	 * 
	 * @return 事件
	 */
	public MetaBaseScript getAction() {
		return this.action;
	}

	/**
	 * 取得字符串事件定义
	 * 
	 * @return 字符串事件定义
	 */
	public String getStringAction() {
		return this.action == null ? null : this.action.getContent();
	}

	/**
	 * 取得可用性
	 * 
	 * @return 可用性标志
	 */
	public String getEnable() {
		return enable;
	}

	/**
	 * 设置可用性
	 * 
	 * @param enable
	 *            可用性标志
	 */
	public void setEnable(String enable) {
		this.enable = enable;
	}

	/**
	 * 取得可见性标志
	 * 
	 * @return 可见性标志
	 */
	public String getVisible() {
		return visible;
	}

	/**
	 * 设置可见性
	 * 
	 * @param visible
	 *            可见性标志
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 取得图标
	 * 
	 * @return 图标
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 设置图标
	 * 
	 * @param icon
	 *            图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 取得模板标识
	 * 
	 * @return 模板标识
	 */
	public String getTemplateKey() {
		return templateKey;
	}

	/**
	 * 设置模板标识
	 * 
	 * @param templateKey
	 *            模板标识
	 */
	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}

	public String getCustomKey() {
		return customKey;
	}

	public void setCustomKey(String customKey) {
		this.customKey = customKey;
	}

	/**
	 * 设置操作的标识
	 * 
	 * @param key
	 *            操作的标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}
	
	public String getI18nCaption() {
		return i18nCaption;
	}

	public void setI18nCaption(String i18nCaption) {
		this.i18nCaption = i18nCaption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(action);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (BPMConstants.NODE_ACTION.equals(tagName)) {
			this.action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			resultMetaObject = this.action;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBPMOperation newBPMOperation = (MetaBPMOperation) newInstance();
		newBPMOperation.setKey(key);
		newBPMOperation.setCaption(caption);
		newBPMOperation.setVisible(visible);
		newBPMOperation.setEnable(enable);
		newBPMOperation.setIcon(icon);
		newBPMOperation.setTemplateKey(templateKey);
		newBPMOperation.setCssClass(cssClass);
		newBPMOperation.setAction(action == null ? null : (MetaBaseScript) action.clone());
		newBPMOperation.setI18nCaption(i18nCaption);
		return newBPMOperation;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMOperation();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("key", key);
		obj.put("caption", caption);
		obj.put("action", this.getStringAction());
		obj.put("enable", enable);
		obj.put("visible", visible);
		obj.put("icon", icon);
		obj.put("template-key", templateKey);
		obj.put("cssClass", cssClass);
		obj.put("customKey", customKey);
		obj.put("i18nCaption", i18nCaption);

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		this.key = json.optString("key");
		this.caption = json.optString("caption");
		String s = json.optString("action");
		if (s != null && !s.isEmpty()) {
			this.action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			this.action.setContent(s);
		}
		this.enable = json.optString("enable");
		this.visible = json.optString("visible");
		this.icon = json.optString("icon");
		this.templateKey = json.optString("template-key");
		this.cssClass = json.optString("cssClass");
		this.customKey = json.optString("customKey");
		this.i18nCaption = json.optString("i18nCaption");
	}

}
