package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaBPMInfo extends KeyPairMetaObject {

	public final static String TAG_NAME = "BPMInfo";

	private String key = "";

	private String caption = "";

	/**
	 * @return the caption
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * @param caption
	 *            the caption to set
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * @param key
	 *            the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBPMInfo newBPMInfo = (MetaBPMInfo) newInstance();
		newBPMInfo.setKey(key);
		newBPMInfo.setCaption(caption);
		return newBPMInfo;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMInfo();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("key", key);
		obj.put("caption", caption);
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		this.key = json.optString("key");
		this.caption = json.optString("caption");
	}

}
