package com.bokesoft.yigo.meta.bpm.process;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * 流程定义的快照，仅包含KEY、名称、版本信息，是进行流程目录扫描的结果。
 * 
 * @author 刘翔翔
 *
 */
public class ProcessDefinitionProfile {

	/** 流程KEY */
	private String key = "";

	/** 流程名称 */
	private String caption = "";

	/** 流程版本 */
	private int version = 1;

	/** 资源路径 */
	private String resource = "";

	/** 流程元文件 */
	private MetaProcess defination = null;
	
	/** 工程引用 */
	private IMetaProject project = null;
	
	private JSONObject definationJson = null;
	
	private IJsonUnserializer jsonUnserializer = null;
	/** 流程配置来源类型*/
	private String sourceType = "";

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public String getResource() {
		return resource;
	}

	public void setResource(String resource) {
		this.resource = resource;
	}

	public MetaProcess getDefination() {
		return defination;
	}

	public void setDefination(MetaProcess defination) {
		this.defination = defination;
		defination.doPostProcess();
	}

	public IMetaProject getProject() {
		return project;
	}

	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	public void setDefinationJson(JSONObject definationJson) {
		this.definationJson = definationJson;
	}
	
	public JSONObject getDefinationJson() {
		return definationJson;
	}
	
	public void setJsonUnserializer(IJsonUnserializer jsonUnserializer){
		this.jsonUnserializer = jsonUnserializer;
	}
	
	public IJsonUnserializer getJsonUnserializer(){
		return jsonUnserializer;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}
	
	public String getSourceType() {
		return sourceType;
	}
}
