package com.bokesoft.yigo.meta.base;

import com.bokesoft.yigo.common.exception.CoreException;

/**
 * 配置异常类 大类编号:8003
 * 创建时间2013-12-27
 * 
 * @author 王元和
 * @since YES1.0
 */
public class MetaException extends CoreException {
	private static final long serialVersionUID = 1L;

	/** 无数据标记没有关联的事件定义 */
	public static final int NO_ACTION_DEFINED = 0x0001;
	/** 不支持的元数据标记 */
	public static final int UNSUPPORTED_TAG_NAME = 0x0002;
	/** 表单配置未定义 */
	public static final int NO_FORM_DEFINED = 0x0003;
	/** 启示工程未定义 */
	public static final int START_PROJECT_UNDEFINED = 0x0004;
	/** 启示表单界面未定义 */
	public static final int START_FORM_UNDEFINED = 0x0005;
	/** 表单元关联数据对象定义 */
	public static final int FORM_WITHOUT_DEFINED_DATAOBJECT = 0x0006;
	/** 表格中汇总行无从属分组 */
	public static final int TOTAL_ROW_NO_BELONGS_GROUP = 0x0007;
	/** 表格中汇总列无从属分组 */
	public static final int TOTAL_COLUMN_NO_BELONGS_GROUP = 0x0008;
	/** 表格中没有定义明细行 */
	public static final int NO_DETAIL_DEFINED = 0x0009;
	/** 表单未定义载入操作 */
	public static final int NO_LOAD_DEFINED = 0x000A;
	/** 面板没有匹配的布局 */
	public static final int PANEL_NO_MATCH_LAYOUT = 0x000B;
	/** 节点无创建者 */
	public static final int NO_CREATOR_DEFINED = 0x000C;
	/** 无扩展源定义 */
	public static final int NO_EXPAND_SOURCE_DEFINED = 0x000D;
	/** 无效的应用路径 */
	public static final int INVALID_SOLUTION_PATH = 0x000E;
	/** 无法定位的数据层级 */
	public static final int UNLOCATE_DATA_LEVEL = 0x000F;
	/** 角色配置未定义或不正确 */
	public static final int ROLE_NOT_DEFINED = 0x0010;
	/** 操作员配置未定义或不正确 */
	public static final int OPERATOR_NOT_DEFINED = 0x0011;
	/** 表单未配置数据源 */
	public static final int NO_DATASOURCE_DEFINED = 0x0012;
	/** 明细表单找不到目标表 */
	public static final int NO_TARGET_TABLE_4_DETAIL_FORM = 0x0013;
	/** 表单重复定义 */
	public static final int REPEAT_FORM_DEFINED = 0x0014;
	/** 数据对象重复定义 */
	public static final int REPEAT_DATAOBJECT_DEFINED = 0x0015;
	/** 表单未定义保存操作 */
	public static final int NO_SAVE_DEFINED = 0x0016;
	/** 组件绑定的数据表或列不存在 */
	public static final int DATASOURCE_NOT_EXISTS = 0x0017;
	/** 表单中计算关系存在循环 */
	public static final int CIRCLE_CALC = 0x0018;
	/** 数据对象配置未定义 */
	public static final int NO_DATAOBJECT_DEFINED = 0X0019;
	/** 重复的组件或单元格标识 */
	public static final int REPEAT_COMPONENT_CELL_KEY = 0x001A;
	/** 迁移期间定义错误 */
	public static final int MIGRATION_PERIOD_ERROR = 0x001B;
	/** 绑定的数据字段未定义 */
	public static final int BINDING_FIELD_NOT_DEFINED = 0x001C;
	/** 数据对象未定义主表 */
	public static final int PRIMARY_TABLE_NOT_DEFINED = 0x001D;
	/** 映射未定义表单标识 */
	public static final int MAP_MISS_FORMKEY = 0x001E;
	/** 批量持久化未定义 */
	public static final int BATCH_PERSIST_NOT_DEFINED = 0x001F;
	/** 最大下推量未定义 */
	public static final int MAX_PUSH_VALUE_UNDIFINED = 0x0020;
	/** 映射指向的字段在目标表中不存在 */
	public static final int MAP_TARGET_FIELD_MISS = 0x0021;
	/** 映射指向的目标表中不存在 */
	public static final int MAP_TARGET_TABLE_MISS = 0x0022;
	/** 迁移指向的字段在目标表中不存在 */
	public static final int MIGRATION_TARGET_FIELD_MISS = 0x0023;
	/** 一对一或一对多数据划分中的操作员中未定义OwnerClusterID */
	public static final int OWNER_CLUSTERID_NOT_DEFINED = 0x0024;
	/** 迁移表未定义分组字段 */
	public static final int MIGRATION_GROUP_NOT_DEFINED = 0x0025;
	/** 未定义描述信息 */
	public static final int NO_DESC_DEFINED = 0x0026;
	/** 字典未定义 */
	public static final int ITEMKEY_NOT_DEFINED = 0x0027;
	/** 配置表未定义*/
	public static final int NO_TABLE_DEFINED = 0x0028;
	/** 表格有列拓展,请勿定义分页*/
	public static final int NO_PAGING_ALLOWED_WITH_COLUMNEXPAND = 0x0029;
	/** 表格有行分组,请勿定义分页*/
	public static final int NO_PAGING_ALLOWED_WITH_ROWGROUP = 0x0030;
	/** 表格无明细数据,请勿定义分组*/
	public static final int NO_PAGING_ALLOWED_WITH_NODETAIL = 0x0031;
	/** 命名的查询未找到 */
	public static final int NAMED_QUERY_NOT_FOUND = 0x0032;
	/** 不存在的单据状态值KEY */
	public static final int NO_STATUS_KEY = 0x0033;
	/** 字典ItemKey错误 */
	public static final int ITEMKEY_ERROR = 0x0034;
	/** 表格无明细数据,请勿定义子明细*/
	public static final int NO_SUBDETAIL_ALLOWED_WITH_NODETAIL = 0x0035;
	/** 子明细绑定的表格未找到*/
	public static final int PARENT_GRID_NOT_FOUND = 0x0036;
	/** 子明细绑定的单元格未找到*/
	public static final int BINDING_CELL_NOT_FOUND = 0x0037;
	/** 列未定义*/
	public static final int NO_COLUMN_DEFINED = 0x0038;
	/** 列未定义*/
	public static final int COLUMN_UNDEFINED = 0x0039;
	/** 子明细未配置根节点*/
	public static final int ROOT_UNDEFINED = 0x0040;
	/** 错误的菜单路径*/
	public static final int WRONG_ENTRY_PATH = 0x0041;
	/** 映射不存在*/
	public static final int NO_DATAMAP = 0x0042;
	/** 迁移扩展属性错误*/
	public static final int MIGRATIONEXTENSION_ERROR = 0x0043;
	/** 下推主表不存在*/
	public static final int MAP_PRIMARY_TABLE_NOT_SET = 0x0044;
	/** 表格列标识重复*/
	public static final int REPEAT_GRID_COLUMN = 0x0045;
	/** 平面图标识重复 */
	public static final int REPEAT_FLATCANVAS_DEFINED = 0x0046;
	/** 模板的rootKey对应的组件未找到*/
	public static final int TEMPLATE_ROOT_NOT_FOUND = 0x0047;
	/** 未配置多语言*/
	public static final int LOCALE_STRING_UNDEFINED = 0x0048;
	/** 数据簇表未定义*/
	public static final int DATA_CLUSTER_TABLE_UNDEFINED = 0x0049;
	/** 表单类型不一致*/
	public static final int FORM_TYPE_DOES_NOT_MATCH = 0x0050;
	/** 控件类型不一致*/
	public static final int CONTROL_TYPE_DOES_NOT_MATCH = 0x0051;
	/** 应用程序不支持混合式表单 */
	public static final int NO_SUPPORT_MIXED_FORM = 0x0052;
	/** 数据源定义不一致*/
	public static final int DATASOURCE_MISMATCH = 0x0053;
	/** 节点{1}关系定义错误*/
	public static final int MAP_RELATION_DEFINITION_ERROR = 0x0054;
	/** 汇集节点{1}未定义主副集*/
	public static final int MAP_JOIN_NO_PRIMATY = 0x0055;
	/** 查询参数定义错误*/
	public static final int QUERY_PARAMETER_DEFINITION_ERROR = 0x0056;
	/** 表单无打印模板定义 */
	public static final int NO_PRINT_TEMPLATE_DEFINED = 0x0057;
	/** 表格列拓展未定义列标识 */
	public static final int EXPAND_COLUMNKEY_UNDEFIND = 0x0058;
	/** 工程载入方式未找到*/
	public static final int PROJECT_RESOLVER_UNDEFINED = 0x0059;
	/** 未找到组件或者单元格配置信息*/
	public static final int PROPERTIES_UNDEFINED = 0x0060;
	/** 数据迁移重复定义*/
	public static final int REPEAT_DATA_MIGRATION_DEFINED = 0x0061;
	/** 数据映射重复定义*/
	public static final int REPEAT_DATA_MAP_DEFINED = 0x0062;
	/** 流程重复部署 */
	public static final int REPEAT_PROCESS_DEPLOY = 0x0063;
	/** 流程重复定义*/
	public static final int REPEAT_PROCESS_DEFINED = 0x0064;
	/** 打印模板重复定义*/
	public static final int REPEAT_REPORE_DEFINED = 0x0065;
	
	public static final int REPEAT_EXT_SERVICE_DEFINED = 0x0066;
	public static final int REPEAT_EXT_IMPORT_SERVICE_DEFINED = 0x0067;
	public static final int REPEAT_EXT_EXPORT_SERVICE_DEFINED = 0x0068;
	public static final int REPEAT_EXT_POST_EXPORT_SERVICE_DEFINED = 0x0069;
	public static final int REPEAT_RELATION_DEFINED = 0x006A;
	public static final int REPEAT_MAPPING_DEFINED = 0x006B;
	public static final int REPEAT_EXCEL_TEMPLATE_DEFINED = 0x006C;
	
	public static final int SOLUTION_NO_RIGHTS_DEFINED_ERROR = 0x006D;
	public static final int REPEAT_BPM_MONITOR_LOGGER_DEFINED = 0x006E;
	public static final int REPEAT_BIZ_EXTEND_DEFINED = 0x006F;
	public static final int REPEAT_RELATION_CHECK_DEFINED = 0x0070;
	
	public static final int REPEAT_KEY_DEFINED = 0x0071;
	public static final int REPEAT_PROJECT_DEFINED = 0x0072;
	public static final int REPEAT_JAR_FILE_DEFINED = 0x0073;
	
	/** 模板中有数据对象未定义*/
	public static final int TEMPLATE_DATAOBJECT_NOT_DEFINED = 0x0074;
	/** 重复的任务流程定义*/
	public static final int REPEAT_TASKFLOW_DEFINED = 0x0075;
	
	public static final int NO_ROOT_CONTROL = 0x0076;
	
	public static final int MAIN_PANEL_NOT_DEFINED = 0x0077;
	
	/** FluidTableLayout 缺失列定义*/
	public static final int MISS_COLUMN_DEFINITION = 0x0078;
	
	/** GridLayout 子组件的行定义超出范围*/
	public static final int ROW_DEFINITION_OUT_RANGE = 0x0079;
	/** GridLayout 子组件的列定义超出范围*/
	public static final int COLUMN_DEFINITION_OUT_RANGE = 0x007A;
	
	/** Rotator的自动切换时间不得小于切换动画的时间*/
	public static final int ROTATOR_ANIMTIME_GREATER_THAN_OR_EQUAL_TO_INTERVALTIME = 0x007B;
	
	/** ShrinkView的内部垂直滚动组件未定义*/
	public static final int SHRINK_VIEW_VERTICAL_SCROLL_COMPONENT_NOT_FOUND = 0x007C;
	
	/** SplitPane 子控件的对应size未定义*/
	public static final int NO_DEFINITION_OF_SIZE = 0x007D;

	/** TableView的明细行TableRow定义了指示器却没定义指示器对应的来源列*/
	public static final int TABLEROW_NO_INDICATOR_KEY = 0x007E;


	/** ProgressBar和Slider的最大值必须大于最小值*/
	public static final int COMPONENT_MAX_NOT_GREATER_THAN_MIN = 0x0080;
	/** ProgressBar和Slider的步进值不能小于0*/
	public static final int COMPONENT_STEP_LESS_THAN_ZERO = 0x0081;
	/** ProgressBar和Slider的取值范围不能被步进值整除*/
	public static final int COMPONENT_RANGE_CAN_NOT_BE_DIVISIBLE_BY_STEP = 0x0082;
	/** StepEditor的步进值精度小于最大值或者最小值的精度*/
	public static final int COMPONENT_STEP_VALUE_ACCURACY_IS_LESS = 0x0083;

	/** TableView中只允许一个分组行有个列表指示器*/
	public static final int TABLE_VIEW_ONLY_ALLOW_ONE_GROUP_ROW_HAS_INDICATOR = 0x0084;


	/** 数据迁移配置定义*/
	public static final int NO_DATA_MIGRATION_DEFINDE = 0x1075;
	
	/** 数据元素未定义*/
	public static final int NO_DATAELEMENT_DEFINED = 0x1076;
	
	/** 域未定义*/
	public static final int NO_DOMAIN_DEFINED = 0x1077;
	
	/** 属性冲突*/
	public static final int ATTRIBUTE_CONFLICT = 0x1078;
	/** 配置元素加载失败*/
	public static final int META_LOAD_ERROR = 0x1079;
	/** 子叶列数量与单元格数量不一致*/
	public static final int COLUMN_CELL_NOT_EQUAL = 0x1080;
	/** 额外操作未定义标识*/
	public static final int EXTOPT_KEY_UNDEFINED = 0x1081;
	
	/** 表标识未定义 */
	public static final int TABLE_KEY_UNDEFINED = 0x1082;
	/** Solution之间存在ParaGroup重复定义 */
	public static final int REPEAT_PARA_GROUP_DEFINED = 0x1083;
	
	public MetaException(int code, String message) {
		super(code, message);
	}
	
	public MetaException(int code, String message, Throwable e) {
		super(code, message, e);
	}
	

	@Override
	protected int getGroupCode() {
		return 0x8003;
	}
}
