package com.bokesoft.yigo.meta.base;

import com.bokesoft.yigo.common.struct.IKeyPair;

public abstract class KeyPairMetaObject extends AbstractMetaObject implements IKeyPair, Comparable<KeyPairMetaObject> {

	/**
	 * 获取对象标识
	 * 
	 * @return 标识
	 */
	public abstract String getKey();
	
	/**
	 * 设置对象标识,子类重写
	 * @param key
	 */
	public void setKey(String key){ throw new UnsupportedOperationException(); };

	public int compareTo(KeyPairMetaObject o) {
		String key = getKey();
		String anotherKey = o.getKey();
		return key.compareToIgnoreCase(anotherKey);
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}
}
