package com.bokesoft.yigo.meta.base;

import java.io.InputStream;
import java.util.List;

public interface IConfigResolver {
	
	/**
	 * 读取资源
	 * @param parentPath 大多数情况指向配置路径
	 * @param prefix 相对于配置路径的前缀路径
	 * @param resource 资源路径
	 * @param type 类型
	 * @return 资源的输入流
	 * @throws Exception 读取异常
	 */
	public InputStream read(String parentPath, String prefix, String resource, int type) throws Exception;
	
	/**
	 *	写入指定资源
	 * @param parentPath 大多数情况指向配置路径
	 * @param prefix 相对于配置路径的前缀路径
	 * @param resource 资源路径
	 * @param data 二进制数据
	 * @return 是否写入成功
	 * @throws Exception 异常
	 */
	public boolean write(String parentPath, String prefix, String resource, byte[] data) throws Exception;
	
	/**
	 * 获取目录下的资源列表
	 * @param parentPath 配置路径
	 * @param prefix 相对于配置路径的前缀路径
	 * @param resource 目录路径
	 * @param flag 文件过滤标识，一般通过文件名来过滤无关文件
	 * @param resources 资源列表
	 * @param names 资源名称集合
	 * @param flags 资源标识：true-为目录资源；false-为文件资源
	 * @return 资源列表的数目
	 * @throws Exception 异常
	 */
	public int listResource(String parentPath, String prefix, String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception;
	
	/**
	 * 获取资源的绝对路径
	 * @param parentPath 大多数情况指向配置路径
	 * @param prefix 相对于配置路径的前缀路径
	 * @param resource 资源路径
	 * @return
	 */
	public String getPath(String parentPath, String prefix, String resource);
}
