package com.bokesoft.yigo.meta.archive;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ArchiveType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaArchiveRule  extends KeyPairMetaObject {
	
	public final static String TAG_NAME="ArchiveRule";
	
	private MetaArchiveObjectCollection objectCollection = null;
	
	private MetaFieldCollection fieldCollection = null;
	/** 规则标识*/
	private String key = "";
	/** 规则描述*/
	private String caption = "";
	/** 归档类型*/
	private Integer type = ArchiveType.NORMAL;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {objectCollection,fieldCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaArchiveObjectCollection.TAG_NAME)) {
			resultMetaObject = new MetaArchiveObjectCollection();
			objectCollection = (MetaArchiveObjectCollection)resultMetaObject;
		} else if (tagName.equalsIgnoreCase(MetaFieldCollection.TAG_NAME)) {
			resultMetaObject = new MetaFieldCollection();
			fieldCollection = (MetaFieldCollection)resultMetaObject;
		} 
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaArchiveRule newObj = new MetaArchiveRule();
		newObj.key = key;
		newObj.caption = caption;
		newObj.type = type;
		newObj.objectCollection = objectCollection == null ? null : (MetaArchiveObjectCollection)objectCollection.clone();
		newObj.fieldCollection = fieldCollection == null ? null : (MetaFieldCollection)fieldCollection.clone();
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaArchiveRule();
	}

	public void setKey(String key){
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	public void setCaption(String caption){
		this.caption = caption;
	}
	
	public String getCaption(){
		return this.caption;
	}
	
	public MetaArchiveObjectCollection getObjectCollection(){
		return objectCollection;
	}
	
	public MetaFieldCollection getFieldCollection(){
		return fieldCollection;
	}

	public void setObjectCollection(MetaArchiveObjectCollection objectCollection) {
		this.objectCollection = objectCollection;
	}

	public void setFieldCollection(MetaFieldCollection fieldCollection) {
		this.fieldCollection = fieldCollection;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	
	
	
}
