package com.bokesoft.yes.meta.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;

/**
 * 用于处理表单间的继承
 *
 * @author 陈瑞
 */
public class MetaFormExtendProcess {
    private IMetaFactory metaFactory;
    private MetaForm metaForm;
    private MetaForm extForm;
    private StringHashMap<MetaComponent> comsMap = null;

    public MetaFormExtendProcess(IMetaFactory metaFactory, MetaForm metaForm) {
        super();
        this.metaFactory = metaFactory;
        this.metaForm = metaForm;
        this.comsMap = StringHashMap.newInstance();
    }

    private void buildMap() {
        MetaBody metaBody = metaForm.getMetaBody();

        Stack<MetaComponent> stack = new Stack<MetaComponent>();
        for (int i = 0, size = metaBody.size(); i < size; ++i) {
            stack.push(metaBody.get(i));
        }

        MetaComponent com = null;
        while (!stack.isEmpty()) {
            com = stack.pop();
            this.comsMap.put(com.getKey(), com);

            for (int i = 0, size = com.getComponentCount(); i < size; ++i) {
                stack.add(com.getComponent(i));
            }
        }
    }

    public void process() throws Throwable {
        String extend = metaForm.getExtend();
        if (extend == null || extend.isEmpty()) {
            return;
        }

        buildMap();

        extForm = metaFactory.getMetaForm(extend);
        processNewExtField();
        processComponents();
        processOptCollection();
        processMacroCollection();
        processQueryCollection();
        processParaCollection();
        processScriptCollection();
        processUICheckCollection();

        metaForm.merge(extForm);
    }

    public void process(MetaForm parentForm) throws Throwable {
        buildMap();

        extForm = parentForm;
        processNewExtField();
        processComponents();
        processOptCollection();
        processMacroCollection();
        processQueryCollection();
        processParaCollection();
        processScriptCollection();
        processUICheckCollection();

        metaForm.merge(extForm);
    }

    /**
     * 相同Key进行merge,其余的进行合并
     */
    private void processOptCollection() throws Throwable {
        MetaOperationCollection oc = metaForm.getOperationCollection();
        MetaOperationCollection oc2 = extForm.getOperationCollection();
        if (oc2 != null) {
            if (oc != null) {
                Iterator<KeyPairCompositeObject> it = oc2.iterator();
                KeyPairCompositeObject metaItem = null;
                KeyPairCompositeObject metaItem2 = null;
                MetaOperation metaOpt = null;
                while (it.hasNext()) {
                    metaItem = it.next();
                    metaItem2 = oc.get(metaItem.getKey());
                    if (metaItem2 != null) { // 包含的merge
                        if (metaItem2.getObjectType() == MetaOperation.Operation) {
                            metaOpt = (MetaOperation) metaItem2;
                            metaOpt.merge((MetaOperation) metaItem);
                        } else {
                            MetaOperationCollection metaOpts = (MetaOperationCollection) metaItem;
                            MetaOperationCollection metaOpts2 = (MetaOperationCollection) metaItem2;
                            metaOpts2.merge(metaOpts);

                            Iterator<KeyPairCompositeObject> itr = metaOpts.iterator();
                            while (itr.hasNext()) {
                                metaOpt = (MetaOperation) itr.next();
                                metaItem2 = metaOpts2.get(metaOpt.getKey());
                                if (metaItem2 != null) {
                                    ((MetaOperation) metaItem2).merge(metaOpt);
                                } else {
                                    metaOpts2.add((KeyPairCompositeObject) metaOpt.clone());
                                }
                            }
                        }
                    } else { // 不包含合并
                        AbstractMetaObject clone = metaItem.clone();
                        if (clone instanceof MetaOperationCollection) {
                            ((MetaOperationCollection) clone).setVisible("return FaLse");
                        } else if (clone instanceof MetaOperation) {
                            ((MetaOperation) clone).setVisible("return FaLse");
                        }
                        oc.add((KeyPairCompositeObject) clone);
                    }
                }
            } else { // 没有定义操作集合,全部复制过来
                AbstractMetaObject clone = oc2.depthClone();
                ((MetaOperationCollection) clone).setVisible("return FaLse");
                metaForm.setOperationCollection((MetaOperationCollection) clone);
            }
        }
    }

    /**
     * 处理继承组件属性并合并父组件
     */
    private void processComponents() throws Exception {
        List<MetaComponent> extComs = extForm.getAllComponents();
        Iterator<MetaComponent> it = extComs.iterator();
        MetaComponent metaCom = null;
        MetaComponent extCom = null;
        MetaComponent cloneCom = null;

        MetaBlock block = metaForm.getPrimaryBlock();
        MetaPanel root = (MetaPanel) block.getRoot();

        while (it.hasNext()) {
            extCom = it.next();

            metaCom = this.comsMap.get(extCom.getKey());

            if (metaCom != null) {
                if (metaCom.getControlType() != extCom.getControlType()) {
                    throw new MetaException(MetaException.CONTROL_TYPE_DOES_NOT_MATCH,
                            SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ControlTypeDoesNotMatch), metaForm.getKey()));
                }

                switch (metaCom.getControlType()) {
                    case ControlType.GRID:
                        processGrid((MetaGrid) metaCom, (MetaGrid) extCom);
                        break;
                    case ControlType.LISTVIEW:
                        processListView((MetaListView) metaCom, (MetaListView) extCom);
                        break;
                    default:
                        metaCom.merge(extCom);
                        break;
                }
            } else {
                if (!extCom.isPanel()) {
                    if ((extCom instanceof MetaSubDetail && ((MetaSubDetail) extCom).getRoot() instanceof MetaGrid)
                            || (extCom instanceof MetaSubDetail && ((MetaSubDetail) extCom).getRoot() instanceof MetaGridLayoutPanel)) {
                        // 不处理
                    } else {
                        if (!this.metaForm.getAllUIComponents().containsKey(extCom.getKey())){
                            cloneCom = (MetaComponent) extCom.depthClone();
                            cloneCom.setExtend(true);
                            cloneCom.setVisible("false");
                            root.addComponent(cloneCom);
                        }
                    }
                }
            }
        }

    }
    /**
     * 处理未继承组件设置NewExtField属性为true
     */
    private void processNewExtField() {
        List<MetaComponent> metaComs = this.metaForm.getAllComponents();
        this.comsMap.forEach((key,metaCom)->{
            if (extForm.componentByKey(key) == null) {
                if (!metaCom.isPanel()) {
                    if ((metaCom instanceof MetaSubDetail && ((MetaSubDetail) metaCom).getRoot() instanceof MetaGrid)
                            || (metaCom instanceof MetaSubDetail && ((MetaSubDetail) metaCom).getRoot() instanceof MetaGridLayoutPanel)) {
                        // 不处理
                    } else {
                        metaCom.setNewExtField(true);
                    }
                }
            }
        });
    }

    private void processListView(MetaListView metaListView, MetaListView extListView) {
        // 自身属性
        metaListView.merge(extListView);

        // 列合并
        MetaListViewColumnCollection lvc = metaListView.getColumnCollection();
        MetaListViewColumnCollection elvc = extListView.getColumnCollection();
        Iterator<MetaListViewColumn> it = lvc.iterator();

        MetaListViewColumn lvColumn = null;
        MetaListViewColumn extColumn = null;

        while (it.hasNext()) {
            lvColumn = it.next();
            extColumn = elvc.get(lvColumn.getKey());

            if (extColumn != null) { // 合并列
                lvColumn.merge(extColumn);
            } else { // 新增的列
                lvColumn.merge(new MetaListViewColumn());
            }

            // 其他不做处理
        }
    }

    /**
     * 处理表格本身以及行和单元格属性的继承,源表格中未被继承的列合并到马甲新的表格中   // TODO  需要添加源表格的列？？？而不是继承表单保证表格的完整性
     */
    private void processGrid(MetaGrid metaGrid, MetaGrid extGrid) {
        // 自身属性
        metaGrid.merge(extGrid);

        MetaGridCell extCell = null;

        // 记录源表格没有被继承的单元格
        MetaGridRowCollection rowCollection = extGrid.getRowCollection();
        Iterator<MetaGridRow> rowCollectionItr = rowCollection.iterator();
        MetaGridRow metaRow1 = null;
        MetaGridRow extRow1 = null;

        while (rowCollectionItr.hasNext()) {
            extRow1 = rowCollectionItr.next();
            metaRow1 = metaGrid.findRowByKey(extRow1.getKey());
            if (metaRow1 != null) {
                for (MetaGridCell metaCell : extRow1) {
                    extCell = metaRow1.findCellByKey(metaCell.getKey());
                    if (extCell == null) { // 没有找到源单元格
                        metaCell.setIsVestDeleteCol(true);
                    }
                }
            } else { // 没有找到源行
                for (MetaGridCell metaCell : extRow1) { // setIsVestDeleteCol
                    metaCell.setIsVestDeleteCol(true);
                }
            }
        }




        // 行,按定义的显示
        MetaGridRowCollection grc = metaGrid.getRowCollection();

        Iterator<MetaGridRow> itr = grc.iterator();
        MetaGridRow metaRow = null;
        MetaGridRow extRow = null;


        // 不要删除行,不需要的行隐藏,合并行在全固定的时候会有问题
        while (itr.hasNext()) {
            metaRow = itr.next();
            extRow = extGrid.findRowByKey(metaRow.getKey());

            if (extRow != null) { // 找到源行,进行合并
                metaRow.merge(extRow);

                for (MetaGridCell metaCell : metaRow) {
                    extCell = extRow.findCellByKey(metaCell.getKey());
                    if (extCell != null) { // 找到源单元格,进行合并
                        metaCell.merge(extCell);
                    } else { // 新增的单元格,合并一个空的
                        metaCell.setNewExtField(true);
                        metaCell.merge(newEmptyCell(metaCell.getCellType()));
                    }
                }

            } else { // 新增的行
                metaRow.merge(newEmptyRow(metaRow.getRowType())); // 合并一个空行

                for (MetaGridCell metaCell : metaRow) { // 重置新增行继承的单元格属性
                    metaCell.setNewExtField(true);
                    metaCell.merge(newEmptyCell(metaCell.getCellType()));
                }
            }
        }

        MetaGridColumnCollection gcc = metaGrid.getColumnCollection();

        Iterator<MetaGridColumn> it = gcc.iterator();
        MetaGridColumn metaColumn = null;
        MetaGridColumn extColumn = null;

        // 记录当前表格子叶列
        Map<String, MetaGridColumn> map = StringHashMap.newInstance();

        // 处理合并列,处理所有列,不光子叶列,找到父列进行合并,找不到,合并一个空列,记录子叶列
        while (it.hasNext()) {
            metaColumn = it.next();
            mergeColumn(extGrid, metaColumn, map);
        }

        List<MetaGridColumn> columns = new ArrayList<MetaGridColumn>();
        getLeafColumns(columns, extGrid.getColumnCollection());

        it = columns.iterator();

        // 添加源表格没有被继承的子叶,在新表格肯定也是子叶
        while (it.hasNext()) {
            extColumn = it.next();
            metaColumn = map.get(extColumn.getOldKey());
            if (metaColumn == null) { // 当前表格中不存在,合并过来
                addExtColumn(metaGrid, extGrid, (MetaGridColumn) extColumn.clone());
            }
        }
    }

    private void mergeColumn(MetaGrid extGrid, MetaGridColumn metaColumn, Map<String, MetaGridColumn> map) {
        MetaGridColumn extColumn = extGrid.findColumnByKey(metaColumn.getKey());
        if (extColumn != null) {
            metaColumn.merge(extColumn);
        } else {
            metaColumn.merge(newEmptyColumn());
        }
        MetaGridColumnCollection columns = metaColumn.getColumnCollection();
        if (columns != null && columns.size() > 0) {
            for (MetaGridColumn column : columns) {
                mergeColumn(extGrid, column, map);
            }
        } else {
            map.put(metaColumn.getOldKey(), metaColumn);
        }
    }

    private void getLeafColumns(List<MetaGridColumn> columns, MetaGridColumnCollection collection) {
        Iterator<MetaGridColumn> it = collection.iterator();
        while (it.hasNext()) {
            MetaGridColumn column = it.next();
            MetaGridColumnCollection children = column.getColumnCollection();
            if (children != null && children.size() > 0) {
                getLeafColumns(columns, children);
            } else {
                columns.add(column);
            }
        }
    }

    // 创建一个空列
    private MetaGridColumn newEmptyColumn() {
        MetaGridColumn metaColumn = new MetaGridColumn();
        return metaColumn;
    }

    // 根据类型,创建一个新的空行
    private MetaGridRow newEmptyRow(int rowType) {
        MetaGridRow metaRow = new MetaGridRow();
        metaRow.setRowType(rowType);
        return metaRow;
    }

    // 根据类型,创建一个新的空单元格
    private MetaGridCell newEmptyCell(int cellType) {
        MetaGridCell metaCell = new MetaGridCell();
        metaCell.setCellType(cellType);
        metaCell.setDataBinding(new MetaDataBinding());
        metaCell.ensureProperties();
        return metaCell;
    }

    // 单元格
    private void addExtColumn(MetaGrid metaGrid, MetaGrid extGrid, MetaGridColumn metaColumn) {
        MetaGridColumnCollection columns = metaGrid.getColumnCollection();
        columns.add(metaColumn);

        setVisible(metaColumn);

        int colIndex = extGrid.getColumnIndex(metaColumn.getKey());

        MetaGridRowCollection grc1 = metaGrid.getRowCollection();
        Iterator<MetaGridRow> itr1 = grc1.iterator();

        MetaGridRow row1 = null;
        MetaGridRow row2 = null;

        while (itr1.hasNext()) {
            row1 = itr1.next();
            row2 = extGrid.findRowByKey(row1.getKey());
            if (row2 != null) {
                row1.add((MetaGridCell) row2.get(colIndex).clone());
            } else {
                row1.add(newEmptyCell(ControlType.LABEL));
            }
        }
    }

    // 设置列可见性
    private void setVisible(MetaGridColumn metaColumn) {
        MetaGridColumnCollection columns = metaColumn.getColumnCollection();
        if (columns != null && !columns.isEmpty()) {
            for (MetaGridColumn column : columns) {
                setVisible(column);
            }
        } else {
            metaColumn.setVisible("return False;");
            metaColumn.setIsVestDeleteCol(true);
        }
    }

    /**
     * 合并宏公式
     */
    private void processMacroCollection() {
        MetaMacroCollection mac1 = metaForm.getMacroCollection();
        MetaMacroCollection mac2 = extForm.getMacroCollection();
        MetaMacroCollection mac3 = null;
        if (mac2 != null) {
            if (mac1 != null) {
                Iterator<MetaMacro> it = mac2.iterator();
                MetaMacro macro = null;
                MetaMacro macro1 = null;

                while (it.hasNext()) {
                    macro = it.next();

                    macro1 = mac1.get(macro.getKey());
                    if (macro1 != null) {
                        macro1.merge(macro);
                    } else {
                        mac1.add((MetaMacro) macro.clone());
                    }
                }
                mac3 = mac1;
            } else {
                mac3 = (MetaMacroCollection) mac2.clone();
            }

            metaForm.setMacroCollection(mac3);
        }
    }

    /**
     * 合并查询
     */
    private void processQueryCollection() {
        MetaQueryCollection qc1 = metaForm.getQueryCollection();
        MetaQueryCollection qc2 = extForm.getQueryCollection();
        MetaQueryCollection qc = null;
        if (qc2 != null) {
            if (qc1 != null) {
                Iterator<MetaQuery> it = qc2.iterator();
                MetaQuery query = null;
                MetaQuery query2 = null;

                while (it.hasNext()) {
                    query = it.next();
                    query2 = qc1.get(query.getKey());

                    if (query2 != null) {
                        query2.merge(query);
                    } else {
                        qc1.add((MetaQuery) query.clone());
                    }
                }
                qc = qc1;
            } else {
                qc = (MetaQueryCollection) qc2.clone();
            }

            metaForm.setQueryCollection(qc);
        }
    }

    /**
     * 合并参数集
     *
     * @throws Throwable
     */
    private void processParaCollection() throws Throwable {
        MetaFormParaCollection pc1 = metaForm.getFormParaCollection();
        MetaFormParaCollection pc2 = extForm.getFormParaCollection();
        MetaFormParaCollection pc3 = null;
        if (pc2 != null) {
            if (pc1 != null) {
                Iterator<MetaFormPara> it = pc2.iterator();
                MetaFormPara p1 = null;
                MetaFormPara p2 = null;

                while (it.hasNext()) {
                    p1 = it.next();
                    p2 = pc1.get(p1.getKey());

                    if (p2 != null) {
                        p2.merge(p1);
                    } else {
                        pc1.add((MetaFormPara) p1.clone());
                    }
                }
                pc3 = pc1;
            } else {
                pc3 = (MetaFormParaCollection) pc2.clone();
            }

            metaForm.setFormParaCollection(pc3);
        }
    }

    /**
     * 合并脚本
     */
    private void processScriptCollection() throws Throwable {
        MetaScriptCollection sc1 = metaForm.getScriptCollection();
        MetaScriptCollection sc2 = extForm.getScriptCollection();
        MetaScript sc = null;

        if (sc2 != null) {
            MetaScript load = sc2.getLoad();
            MetaScript save = sc2.getSave();
            if (sc1 != null) {
                if (load != null) {
                    sc = sc1.getLoad();
                    if (sc != null) {
                        sc.merge(load);
                    } else {
                        sc1.setLoad((MetaScript) load.clone());
                    }
                }

                if (save != null) {
                    sc = sc1.getSave();
                    if (sc != null) {
                        sc.merge(save);
                    } else {
                        sc1.setSave((MetaScript) save.clone());
                    }
                }
            } else {
                metaForm.setScriptCollection((MetaScriptCollection) sc2.clone());
            }
        }
    }

    /**
     * 检查规则不合并,直接继承或者覆盖
     */
    private void processUICheckCollection() throws Throwable {
        MetaUICheckRuleCollection co = metaForm.getUICheckRuleCollection();
        if (co == null) {
            MetaUICheckRuleCollection co2 = extForm.getUICheckRuleCollection();
            if (co2 != null) {
                metaForm.setUICheckRuleCollection((MetaUICheckRuleCollection) co2.clone());
            }
        }
    }

}
