package com.bokesoft.yes.meta.persist.dom.xml.defaultnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.yes.common.util.StringUtil;

/**
 * 属性链表
 * @author chenbinbin
 *
 */
public class DefaultNode {

	private LinkedData first = null;
	
	private LinkedData last = null;
	
	private String primaryKey = null;
	
	private boolean isSingle = false;
	
	private String tagName = null;
	
	protected LinkedHashMap<String, LinkedData> attrs = new LinkedHashMap<String, LinkedData>();
	
	public DefaultNode(String tagName) {
		this(tagName, false);
	}
	
	public DefaultNode(String tagName, boolean isSingle) {
		this.tagName = tagName;
		this.isSingle = isSingle;
	}

	public String getTagName() {
		return this.tagName;
	}
	
	public void addNode(LinkedData node) {
		addNode(node, null);
	}
	
	public void addNode(LinkedData node, LinkedData after) {
		if (attrs.size() == 0) {
			first = node;
		}
		attrs.put(node.getValue(), node);
		if (after != null) {
			LinkedData tmp = after.next;
			after.next = node;
			node.previous = after;
			node.next = tmp;
			if (tmp != null) {
				tmp.previous = node;
			} else {
				last = node;
			}
		} else {
			if (last != null) {
				last.next = node;
				node.previous = last;
			}
			last = node;
		}
	}
	
	public LinkedData first() {
		return first;
	}
	
	public LinkedData last() {
		return last;
	}
	
	public LinkedData getNode(String name) {
		return attrs.get(name);
	}
	
	public boolean hasAttribute(String attrName) {
		return attrs.containsKey(attrName);
	}
	
	public boolean hasPrimaryAttribute() {
		return primaryKey != null && primaryKey.trim().length() > 0;
	}
	
	public String getPrimaryKey() {
		return primaryKey;
	}
	
	public void setPrimaryKey(String primaryKey) {
		this.primaryKey = primaryKey;
	}

	public Collection<LinkedData> values() {
		return attrs.values();
	}
	
	public void setSingle(boolean b) {
		this.isSingle = b;
	}
	
	public boolean isSingle() {
		return this.isSingle;
	}
	
	public String toString() {
		StringBuilder strBuilder = new StringBuilder();
		if (DefaultNodeDefine.NODE_CDATA.equals(tagName) || DefaultNodeDefine.NODE_COMMENT.equals(tagName)) {
			strBuilder.append("<").append(tagName);
		} else {
			strBuilder.append("<").append(tagName).append(" ");
			for(Map.Entry<String, LinkedData> entry : attrs.entrySet()) {
				if (!StringUtil.isEmptyStr(entry.getKey())) {
					strBuilder.append(entry.getKey()).append("=").append("\"\"").append(" ");
				}
			}
			strBuilder.deleteCharAt(strBuilder.length() - 1);
			if (this.isSingle) {
				strBuilder.append("/>");
			} else {
				strBuilder.append(">\r\n").append("</").append(tagName).append(">");
			}
		}
		return strBuilder.toString();
	}
	
	public List<String> getAttrList() {
		List<String> list = new ArrayList<String>();
		for(Map.Entry<String, LinkedData> entry : attrs.entrySet()) {
			list.add(entry.getKey());
		}
		return list;
	}
	
	public String[] getPopupArray(List<String> filters) {
		List<String> list = new ArrayList<String>();
		for(Map.Entry<String, LinkedData> entry : attrs.entrySet()) {
			if (filters == null || !filters.contains(entry.getKey())) {
				list.add(entry.getKey());
			}
		}
		String[] arr = new String[list.size()];
		list.toArray(arr);
		return arr;
	}
}
