
package com.bokesoft.yes.meta.persist.dom.taskflow;

/**
 * 任务流程节点类型
 */
public class NodeType {
	
	/** 开始节点　*/
	public static final int START = 0;
	public static final String STR_START = "Start";
	
	/** 结束节点*/
	public static final int END = 1;
	public static final String STR_END = "End";
	
	/** 任务节点*/
	public static final int TASK = 2;
	public static final String STR_TASK = "Task";
	
	/** 分支节点*/
	public static final int FORK = 3;
	public static final String STR_FORK = "Fork";
	
	/** 合并节点*/
	public static final int JOIN = 4;
	public static final String STR_JOIN = "Join";
	
	/** 补偿节点*/
	public static final int COMPENSATION = 5;
	public static final String STR_COMPENSATION = "Compensation";
	
	/** 状态节点*/
	public static final int STATE = 6;
	public static final String STR_STATE = "State";
	
	/**
	 *节点类型
	 * @param s 字符串，取值范围为
	 * <ul>
	 * <li>{@link #STR_START}
	 * <li>{@link #STR_END}
	 * <li>{@link #STR_TASK}
	 * <li>{@link #STR_END}
	 * <li>{@link #STR_FORK}
	 * <li>{@link #STR_JOIN}
	 * <li>{@link #STR_COMPENSATION}
	 * <li>{@link #STR_STATE}
	 * </ul>
	 * @return 如果s的取值在取值范围内，返回相应的运算符，否则返回-1
	 */
	public static int parse(String s) {
		int op = -1;
		if ( STR_START.equals(s) ) {
			op = START;
		} else if ( STR_END.equals(s) ) {
			op = END;
		} else if ( STR_TASK.equals(s) ) {
			op = TASK;
		} else if ( STR_FORK.equals(s) ) {
			op = FORK;
		} else if ( STR_JOIN.equals(s) ) {
			op = JOIN;
		} else if ( STR_COMPENSATION.equals(s) ) {
			op = COMPENSATION;
		} else if ( STR_STATE.equals(s) ) {
			op = STATE;
		}
		return op;
	}
	
	/**
	 * 节点类型字符串表示
	 * @param type 运算符，取值范围为
	 * <ul>
	 * <li>{@link #START}
	 * <li>{@link #END}
	 * <li>{@link #TASK}
	 * <li>{@link #FORK}
	 * <li>{@link #JOIN}
	 * <li>{@link #COMPENSATION}
	 * <li>{@link #STATE}
	 * </ul>
	 * @return 如果type的取值在取值范围内，返回相应的字符串表示，否则返回空字符串
	 */
	public static String format(int type) {
		String s = "";
		switch ( type ) {
		case START:
			s = STR_START;
			break;
		case END:
			s = STR_END;
			break;
		case TASK:
			s = STR_TASK;
			break;
		case FORK:
			s = STR_FORK;
			break;
		case JOIN:
			s = STR_JOIN;
			break;
		case COMPENSATION:
			s = STR_COMPENSATION;
			break;
		case STATE:
			s = STR_STATE;
			break;
		}
		return s;
	}
	
}
