package com.bokesoft.yes.meta.persist.dom.taskflow;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.taskflow.node.MetaTask;

public class MetaTaskAction extends MetaNodeAction<MetaTask> {
	
	@Override
	public void load(Document document, Element element, MetaTask meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTaskName(DomHelper.readAttr(element, MetaConstants.TASK_NAME, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.TASK_IMPL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTask meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TASK_NAME, meta.getTaskName(), "");
		DomHelper.writeAttr(element, MetaConstants.TASK_IMPL, meta.getImpl(), "");
	}

}
