package com.bokesoft.yes.meta.persist.dom.task.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.task.MetaTaskProcess;

public class MetaTaskProcessAction extends BaseDomAction<MetaTaskProcess> {

	@Override
	public void load(Document document, Element element, MetaTaskProcess meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setVersion(DomHelper.readAttr(element, BPMConstants.COMMON_VERSION, 1));
	}

	@Override
	public void save(Document document, Element element, MetaTaskProcess meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, BPMConstants.COMMON_VERSION, meta.getVersion(), 1);
	}

}
