package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.json.JSONObject;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaReportScanLoad extends BaseMetaScanLoad {
	private MetaReportList reportList = null;
	
	List<MetaReportProfile> list = null;
	public MetaReportScanLoad(MetaReportList reportList, IMetaResolver resolver,
			MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.REPORT_FOLD, context);
		this.reportList = reportList;
		list = new CopyOnWriteArrayList<>();
	}
	
	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName)
			throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaReport.TAG_NAME.equals(tagName)) {
				MetaReportProfile profile = new MetaReportProfile();
				profile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				profile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				profile.setFormKey(profileInfo.optString(MetaReportConstants.FORM_KEY));
				String s = profileInfo.optString(MetaReportConstants.REPORT_GROUP);
				profile.setGroup(s == null ? "" : s);
				
				s = profileInfo.optString(MetaReportConstants.REPORT_DEFAULT);
				if ( s != null && !s.isEmpty() ) {
					profile.setDefault(Boolean.parseBoolean(s));
				}
				profile.setProject(metaProject);
				profile.setResource(filePath);
				doFind(parent, parentPath, filePath, fileName, profile);
				list.add(profile);
			}
		}
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaReportProfile profile) {
		
	}
	
	private void merge() {
		if(list.isEmpty()) {
			return;
		}
		try {
			String formKey;
			for(MetaReportProfile profile : list) {
				formKey = profile.getFormKey();
				MetaReportSubList subList = reportList.get(formKey);
				if ( subList == null ) {
					subList = new MetaReportSubList();
					subList.setKey(formKey);
				}
				subList.add(profile);
				reportList.add(subList);
			}
		}finally {
			list.clear();
		}
	}
	
	public MetaReportList getMetaReportList() {
		merge();
		return this.reportList;
	}
}
