package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaInplaceToolbarAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaInplaceToolbarCollectionAction;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbar;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbarCollection;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectFold;
import com.bokesoft.yigo.meta.solution.MetaProjectItem;
import com.bokesoft.yigo.meta.solution.MetaProjectItemCollection;

public class MetaProjectActionMap extends MetaActionMap {
	private MetaProjectActionMap() {
		super();
	}
	
	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaProject.TAG_NAME, new MetaProjectAction() },
				{ MetaProjectItemCollection.TAG_NAME, new MetaProjectItemCollectionAction() },
				{ MetaProjectFold.TAG_NAME, new MetaProjectFoldAction() },
				{ MetaProjectItem.TAG_NAME, new MetaProjectItemAction() },
				{ MetaInplaceToolbarCollection.TAG_NAME, new MetaInplaceToolbarCollectionAction() },
				{ MetaInplaceToolbar.TAG_NAME, new MetaInplaceToolbarAction() }
		};
	}

	private static MetaProjectActionMap instance = null;
	public static MetaProjectActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaProjectActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
