package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaProjectAction extends BaseDomAction<MetaProject> {

	@Override
	public void load(Document document, Element element, MetaProject meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDataPath(DomHelper.readAttr(element, "DataPath", ""));
		meta.setParentProject(DomHelper.readAttr(element, "ParentProject", ""));
		meta.setPlatform(PlatformType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_PLATFORM, PlatformType.STR_All)));
	}

	@Override
	public void save(Document document, Element element, MetaProject meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, "DataPath", meta.getDataPath(), "");
		DomHelper.writeAttr(element, "ParentProject", meta.getParentProject(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_PLATFORM, PlatformType.toString(meta.getPlatform()), PlatformType.STR_All);
	}

}
