package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaSetting;

public class MetaSettingAction extends BaseDomAction<MetaSetting> {

	@Override
	public void load(Document document, Element element, MetaSetting meta, int runType) {
		meta.setDbCluster(DomHelper.readAttr(element, MetaConstants.DB_CLUSTER, false));
		meta.setMessageEnabled(DomHelper.readAttr(element, MetaConstants.MESSAGE_ENABLED, false));
		meta.setPreferencePath(DomHelper.readAttr(element, MetaConstants.PREFERENCE_PATH, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSetting meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DB_CLUSTER, meta.isDbCluster(), false);
		DomHelper.writeAttr(element, MetaConstants.MESSAGE_ENABLED, meta.isMessageEnabled(), false);
		DomHelper.writeAttr(element, MetaConstants.PREFERENCE_PATH, meta.getPreferencePath(), "");
	}

}
