package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TreeMenuBarType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaEntrySetting;

public class MetaEntrySettingAction extends BaseDomAction<MetaEntrySetting> {

	@Override
	public void load(Document document, Element element, MetaEntrySetting meta,
			int runType) {
		meta.setStyle(TreeMenuBarType.parse(DomHelper.readAttr(element, MetaConstants.ENTRY_STYLE, TreeMenuBarType.STR_GroupTree)));
//		meta.setExpand(DomHelper.readAttr(element, MetaConstants.ENTRY_EXPAND, false));
	}

	@Override
	public void save(Document document, Element element, MetaEntrySetting meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.ENTRY_STYLE, TreeMenuBarType.toString(meta.getStyle()), TreeMenuBarType.STR_GroupTree);
//		DomHelper.writeAttr(element, MetaConstants.ENTRY_EXPAND, meta.isExpand(), false);
	}

}
