package com.bokesoft.yes.meta.persist.dom.report.embed.chart;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportSeries;

public class MetaReportSeriesAction extends BaseDomAction<MetaReportSeries> {
	@Override
	public void load(Document document, Element element, MetaReportSeries meta,
			int runType) {
		meta.setDataKey(DomHelper.readAttr(element, MetaConstants.SERIES_DATA_KEY, ""));
		meta.setSource(DomHelper.readAttr(element, MetaConstants.SERIES_SOURCE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaReportSeries meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.SERIES_DATA_KEY, meta.getDataKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SERIES_SOURCE, meta.getSource(), "");
	}

}
