package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportListItem;

public class MetaReportListItemAction extends BaseDomAction<MetaReportListItem> {

	@Override
	public void load(Document document, Element element,
			MetaReportListItem meta, int runType) {
		meta.setValue(DomHelper.readAttr(element, MetaConstants.COMMON_VALUE, ""));
		meta.setText(DomHelper.readAttr(element, MetaConstants.COMMON_TEXT, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaReportListItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TEXT, meta.getText(), "");
	}

}
