package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ContentOverflowType;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportGridCell;
import com.bokesoft.yigo.meta.report.ReportCellContentType;
import com.bokesoft.yigo.meta.report.ReportCellGroupType;
import com.bokesoft.yigo.meta.report.ReportCellSortType;
import com.bokesoft.yigo.meta.report.ReportContentSourceType;

public class MetaReportGridCellAction extends BaseDomAction<MetaReportGridCell> {

	@Override
	public void load(Document document, Element element, MetaReportGridCell meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setContentType(ReportCellContentType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_TYPE, ReportCellContentType.STR_Text)));
		meta.setSourceType(ReportContentSourceType.parse(DomHelper.readAttr(element, MetaReportConstants.CONTENT_SOURCE_TYPE, "")));
		meta.setTableKey(DomHelper.readAttr(element, MetaReportConstants.CONTENT_TABLE_KEY, ""));
		meta.setFieldKey(DomHelper.readAttr(element, MetaReportConstants.CONTENT_FIELD_KEY, ""));
		meta.setFormula(DomHelper.readAttr(element, MetaReportConstants.CONTENT_FORMULA, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaReportConstants.CONTENT_IMPL, ""));
		meta.setPageNo(DomHelper.readAttr(element, MetaReportConstants.CONTENT_PAGENO, ""));
		meta.setGroupType(ReportCellGroupType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_GROUP_TYPE, ReportCellGroupType.STR_None)));
		meta.setMerged(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGED, false));
		meta.setMergedHead(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGED_HEAD, false));
		meta.setMergedRowSpan(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGED_ROW_SPAN, 0));
		meta.setMergedColumnSpan(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGED_COLUMN_SPAN, 0));
		
		meta.setPadding(DomHelper.readAttr(element, MetaReportConstants.CELL_PADDING, ""));
		meta.setOverflow(DomHelper.readAttr(element, MetaReportConstants.CELL_OVERFLOW, ContentOverflowType.None));
		meta.setMergeDetail(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGE_DETAIL, false));
		meta.setMergeTopGroup(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGE_TOP_GROUP, false));
		meta.setMergeBottomGroup(DomHelper.readAttr(element, MetaReportConstants.CELL_MERGE_BOTTOM_GROUP, false));
		meta.setPrimary(DomHelper.readAttr(element, MetaReportConstants.CELL_IS_PRIMARY, false));
		meta.setIsColumnExpand(DomHelper.readAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND, false));
		meta.setIsRowExpand(DomHelper.readAttr(element, MetaReportConstants.CELL_ROW_EXPAND, false));
		meta.setFillEmptyContent(DomHelper.readAttr(element, MetaReportConstants.CELL_FILL_EMPTY_CONTENT, false));
		meta.setImageSourceType(ImageSourceType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_IMAGE_SOURCE_TYPE, ImageSourceType.STR_DATA)));
		meta.setPath(DomHelper.readAttr(element, MetaReportConstants.CELL_PATH, ""));
		meta.setSortType(ReportCellSortType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_SORT_TYPE, ReportCellSortType.STR_None)));
		meta.setSystemContent(DomHelper.readAttr(element, MetaReportConstants.CELL_SYSTEM_CONTENT, ""));
		meta.setSummary(DomHelper.readAttr(element, MetaReportConstants.CELL_IS_SUMMARY, false));
	}

	@Override
	public void save(Document document, Element element, MetaReportGridCell meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_TYPE, ReportCellContentType.toString(meta.getContentType()), ReportCellContentType.STR_Text);
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_SOURCE_TYPE, ReportContentSourceType.toString(meta.getSourceType()), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_TABLE_KEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_FIELD_KEY, meta.getFieldKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_PAGENO, meta.getPageNo(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_GROUP_TYPE, ReportCellGroupType.toString(meta.getGroupType()), ReportCellGroupType.STR_None);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGED, meta.isMerged(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGED_HEAD, meta.isMergedHead(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGED_ROW_SPAN, meta.getMergedRowSpan(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGED_COLUMN_SPAN, meta.getMergedColumnSpan(), 0);
		
		DomHelper.writeAttr(element, MetaReportConstants.CELL_PADDING, meta.getPadding(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_OVERFLOW, meta.getOverflow(), ContentOverflowType.None);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGE_DETAIL, meta.isMergeDetail(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGE_TOP_GROUP, meta.isMergeTopGroup(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_MERGE_BOTTOM_GROUP, meta.isMergeBottomGroup(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_IS_PRIMARY, meta.isPrimary(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND, meta.isColumnExpand(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_ROW_EXPAND, meta.isRowExpand(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_FILL_EMPTY_CONTENT, meta.isFillEmptyContent(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_IMAGE_SOURCE_TYPE, ImageSourceType.toString(meta.getImageSourceType()), ImageSourceType.STR_DATA);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_PATH, meta.getPath(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_SORT_TYPE, ReportCellSortType.toString(meta.getSortType()), ReportCellSortType.STR_None);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_SYSTEM_CONTENT, meta.getSystemContent(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_IS_SUMMARY, meta.isSummary(), false);
	}

}

