package com.bokesoft.yes.meta.persist.dom.relation.path.check;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.check.MetaScript;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaScriptAction extends BaseDomAction<MetaScript> {

	@Override
	public void load(Document document, Element element, MetaScript meta, int runType) {
		meta.setBlacklist(DomHelper.readAttr(element, MetaRelationConstants.BLACKLIST, false));
		meta.setFormKey(DomHelper.readAttr(element, MetaConstants.COMMON_FORMKEY, ""));
		meta.setScriptKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaScript meta, int runType) {
		DomHelper.writeAttr(element, MetaRelationConstants.BLACKLIST, meta.isBlacklist(), false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getScriptKey(), "");
	}

}
