package com.bokesoft.yes.meta.persist.dom.permission.filter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.PermissionFilterStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.permission.filter.MetaFilter;

public class MetaFilterAction extends BaseDomAction<MetaFilter> {

	@Override
	public void load(Document document, Element element, MetaFilter meta, int runType) {
		meta.setStyle(PermissionFilterStyle.parse(DomHelper.readAttr(element, MetaFilterConstants.STYLE, PermissionFilterStyle.STR_PERMISSION)));
		meta.setServiceID(DomHelper.readAttr(element, MetaFilterConstants.SERVICEID, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaFilterConstants.IMPL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaFilter meta, int runType) {
		DomHelper.writeAttr(element, MetaFilterConstants.STYLE, PermissionFilterStyle.toString(meta.getStyle()), PermissionFilterStyle.STR_PERMISSION);
		DomHelper.writeAttr(element, MetaFilterConstants.SERVICEID, meta.getServiceID(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.IMPL, meta.getImpl(), "");
	}

}
