package com.bokesoft.yes.meta.persist.dom.offlinedef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.OfflineConfigType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.offlinedef.MetaConfigInfo;

public class MetaConfigInfoAction  extends BaseDomAction<MetaConfigInfo>{

	@Override
	public void load(Document document, Element element, MetaConfigInfo meta, int runType) {
		meta.setType(OfflineConfigType.parse(DomHelper.readAttr(element, MetaConstants.OFFLINE_CONFIGINFO_TYPE,"")));
		meta.setPath(DomHelper.readAttr(element, MetaConstants.OFFLINE_CONFIGINFO_PATH, ""));
		meta.setProject(DomHelper.readAttr(element, MetaConstants.OFFLINE_CONFIGINFO_PROJECT, ""));
	}

	@Override
	public void save(Document document, Element element, MetaConfigInfo meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.OFFLINE_CONFIGINFO_TYPE, OfflineConfigType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.OFFLINE_CONFIGINFO_PATH, meta.getPath(), "");
		DomHelper.writeAttr(element, MetaConstants.OFFLINE_CONFIGINFO_PROJECT, meta.getProject(), "");
	}
	
}
