package com.bokesoft.yes.meta.persist.dom.mobiledef;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.form.MetaNavigationBarAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaNavigationBarItemAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaNavigationBarLeftButtonAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaNavigationBarRightButtonAction;
import com.bokesoft.yes.meta.persist.dom.form.anim.MetaAnimCollectionAction;
import com.bokesoft.yes.meta.persist.dom.form.anim.MetaAnimItemAction;
import com.bokesoft.yes.meta.persist.dom.form.anim.MetaAnimPropertyAction;
import com.bokesoft.yes.meta.persist.dom.form.anim.MetaAnimPropertyCollectionAction;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaFontAction;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaFormatAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaParaAction;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.MetaNavigationBarItem;
import com.bokesoft.yigo.meta.form.MetaNavigationBarLeftButton;
import com.bokesoft.yigo.meta.form.MetaNavigationBarRightButton;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.form.anim.MetaAnimProperty;
import com.bokesoft.yigo.meta.form.anim.MetaAnimPropertyCollection;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.mobiledef.MetaAppParas;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDef;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDefCollection;
import com.bokesoft.yigo.meta.mobiledef.MetaExtClass;
import com.bokesoft.yigo.meta.mobiledef.MetaExtClassCollection;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundItem;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundPool;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorDef;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorItem;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;
import com.bokesoft.yigo.meta.mobiledef.encrypt.MetaEncryptSetting;

public class MetaMobileDefActionMap extends MetaActionMap {

	private MetaMobileDefActionMap() {
		super();
	}

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] { 
				{ MetaMobileDef.TAG_NAME, new MetaMobileDefAction() },
				{ MetaNavigationBar.TAG_NAME, new MetaNavigationBarAction() },
				{ MetaNavigationBarLeftButton.TAG_NAME, new MetaNavigationBarLeftButtonAction() },
				{ MetaNavigationBarRightButton.TAG_NAME, new MetaNavigationBarRightButtonAction() },
				{ MetaNavigationBarItem.TAG_NAME, new MetaNavigationBarItemAction() },
				{ MetaEventDefCollection.TAG_NAME, new MetaEventDefCollectionAction() },
				{ MetaEventDef.TAG_NAME, new MetaEventDefAction() },
				{ MetaVibratorDef.TAG_NAME, new MetaVibratorDefAction() },
				{ MetaVibratorItem.TAG_NAME, new MetaVibratorItemAction() },
				{ MetaSoundPool.TAG_NAME, new MetaSoundPoolAction() },
				{ MetaSoundItem.TAG_NAME, new MetaSoundItemAction() },
				{ MetaAnimCollection.TAG_NAME, new MetaAnimCollectionAction() },
                { MetaAnimItem.TAG_NAME, new MetaAnimItemAction()}, 
                { MetaAnimProperty.TAG_NAME, new MetaAnimPropertyAction()}, 
                { MetaAnimPropertyCollection.TAG_NAME, new MetaAnimPropertyCollectionAction()}, 
				{ MetaEncryptSetting.TAG_NAME, new MetaEncryptSettingAction() },
                { MetaWatermark.TAG_NAME, new MetaWatermarkAction()},
                { MetaFormat.TAG_NAME, new MetaFormatAction()},
                { MetaFont.TAG_NAME, new MetaFontAction() },
                { MetaAppParas.TAG_NAME, new MetaAppParasAction() },
                { MetaPara.TAG_NAME, new MetaParaAction() },
				{ MetaExtClassCollection.TAG_NAME, new MetaExtClassCollectionAction() },
				{ MetaExtClass.TAG_NAME, new MetaExtClassAction() }};
	}

	private static MetaMobileDefActionMap instance = null;

	public static MetaMobileDefActionMap getInstance() {
		if (instance == null) {
			instance = new MetaMobileDefActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return new Object[][]{
			{MetaEncryptSetting.TAG_NAME,MetaEncryptSettingActionMap.getInstance().getActionLookupTable()}
		};
	}

}
