package com.bokesoft.yes.meta.persist.dom.mapping;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.mapping.MetaMapping;
import com.bokesoft.yigo.meta.mapping.MetaMappingList;
import com.bokesoft.yigo.meta.mapping.MetaMappingProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaMappingScanLoad extends BaseMetaScanLoad {
	/** 映射集合*/
	private MetaMappingList mapList = null;
	private int runType = AppRunType.App;
	public MetaMappingScanLoad(MetaMappingList list, IMetaResolver resolver, MetaProject metaProject,Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.MAPPING_FOLD, context);
		this.mapList = list;
		this.runType = runType;
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaMapping.TAG_NAME.equals(tagName)) {
				MetaMappingProfile profile = new MetaMappingProfile();
				profile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				profile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				profile.setProject(metaProject);
				profile.setImpl(profileInfo.optString(MetaConstants.COMMON_IMPL));
				profile.setResource(filePath);
				if ( mapList.containsKey(profile.getKey())) {
					throw new MetaException(MetaException.REPEAT_MAPPING_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatMappingDefined),
									metaProject.getKey(), profile.getKey()));
				}
				doFind(parent, parentPath, filePath, fileName, profile);
				mapList.add(profile);
			}
		}
		
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaMappingProfile profile) {
		
	}
}

