package com.bokesoft.yes.meta.persist.dom.mapping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mapping.AbstractMapElement;

public class MetaMapElementAction<T extends AbstractMapElement> extends BaseDomAction<T> {

	@Override
	public void load(Document document, Element element, T meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setID(DomHelper.readAttr(element, MetaMappingConstants.ID, -1));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.ID, meta.getID(), -1);
		
	}

}
