package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearItem;

public class MetaLinearItemAction extends MetaLayoutItemAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaLinearItem metaLinearItem = (MetaLinearItem)meta;
		String width = DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "");
		if (width != null && !width.isEmpty()) {
			metaLinearItem.setWidth(DefSize.parse(width));
		}
		String height = DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, "");
		if (height != null && !height.isEmpty()) {
			metaLinearItem.setHeight(DefSize.parse(height));
		}
		String weight = DomHelper.readAttr(element, MetaConstants.COMPONENT_WEIGHT, "");
		if (weight != null && !weight.isEmpty()) {
			metaLinearItem.setWeight(Float.parseFloat(weight));
		}
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaLinearItem metaLinearItem = (MetaLinearItem)meta;
		DefSize width = metaLinearItem.getWidth();
		if (width != null) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), "");
		}
		DefSize height = metaLinearItem.getHeight();
		if (height != null) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, height.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_WEIGHT, String.valueOf(metaLinearItem.getWeight()), "0.0");
	}
}
