package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;

public class MetaLayoutColumnAction extends BaseDomAction<MetaLayoutColumn> {

	@Override
	public void load(Document document, Element element,
			MetaLayoutColumn meta, int runType) {
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "")));
	}

	@Override
	public void save(Document document, Element element,
			MetaLayoutColumn meta, int runType) {
		DefSize width = meta.getWidth();
		if ( width != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), "");
		}
	}

}
