package com.bokesoft.yes.meta.persist.dom.form.component.panel.collapsepanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapseItem;

/**
 * 折叠布局面板在保存和载入时的相关动作
 * 
 * @author MY
 * @since YES1.0
 */
public class MetaCollapseItemAction extends MetaComponentAction<MetaCollapseItem> {

	@Override
	public void load(Document document, Element element, MetaCollapseItem meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COLLAPSE_ICON, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COLLAPSE_CAPTION, ""));
		meta.setTextOn(DomHelper.readAttr(element, MetaConstants.COLLAPSE_TEXTON, ""));
		meta.setTextOff(DomHelper.readAttr(element, MetaConstants.COLLAPSE_TEXTOFF, ""));
		meta.setIsExpand(DomHelper.readAttr(element, MetaConstants.COLLAPSE_ISEXPAND, false));
		meta.setIconLocation(IconLocationType
				.parse(DomHelper.readAttr(element, MetaConstants.COLLAPSE_ICONLOCATION, IconLocationType.STR_LEFT)));
		meta.setCollapseIcon(DomHelper.readAttr(element, MetaConstants.COLLAPSE_COLLAPSE_ICON, ""));
		meta.setExpandIcon(DomHelper.readAttr(element, MetaConstants.COLLAPSE_EXPAND_ICON, ""));
		String collapseHeight = DomHelper.readAttr(element, MetaConstants.COLLAPSE_COLLAPSE_HEIGHT, "");
		if (collapseHeight != null && !collapseHeight.isEmpty()) {
			meta.setCollapseHeight(DefSize.parse(collapseHeight));
		}
	}

	@Override
	public void save(Document document, Element element, MetaCollapseItem meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_TEXTON, meta.getTextOn(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_TEXTOFF, meta.getTextOff(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_ISEXPAND, meta.getIsExpand(), false);
		DomHelper.writeAttr(element, MetaConstants.BUTTON_ICONLOCATION,
				IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_COLLAPSE_ICON, meta.getCollapseIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_EXPAND_ICON, meta.getExpandIcon(), "");
		DefSize collapseHeight = meta.getCollapseHeight();
		if (collapseHeight != null) {
			DomHelper.writeAttr(element, MetaConstants.COLLAPSE_COLLAPSE_HEIGHT, collapseHeight.toString(), "");
		}
	}

}
