package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaLinearLayoutPanel;
/**
 * Android独有<br>
 * 线性布局面板,相关读取方式
 * @author ShiXuyun
 *
 */
public class MetaLinearLayoutPanelAction extends MetaPanelAction<MetaLinearLayoutPanel>{

	@Override
	public void load(Document document, Element element, MetaLinearLayoutPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setOrientation(OrientationType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.STR_Horizontal)));
	}

	@Override
	public void save(Document document, Element element, MetaLinearLayoutPanel meta, int runType) {
		// TODO Auto-generated method stub
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.toString(meta.getOrientation()), OrientationType.STR_Horizontal);
	}
	
}