package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOpt;

public class MetaExtOptAction extends MetaBaseScriptAction<MetaExtOpt> {
	
	@Override
	public void load(Document document, Element element, MetaExtOpt meta,
			int runType) {
		super.load(document, element, meta, runType);
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, ""));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExtOpt meta,
			int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, meta.getEnableDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, meta.getVisibleDependency(), "");
	}

}
