package com.bokesoft.yes.meta.persist.dom.form.component.control.refresh;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.def.RefreshStateType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshState;

public class MetaRefreshStateAction extends BaseDomAction<MetaRefreshState>{

	@Override
	public void load(Document document, Element element, MetaRefreshState meta, int runType) {
		meta.setText(DomHelper.readAttr(element, MetaConstants.COMMON_TEXT, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, null));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.REFRESHCONTROL_ICONLOCATION, IconLocationType.STR_LEFT)));
		meta.setType(RefreshStateType.parse(DomHelper.readAttr(element, MetaConstants.REFRESHCONTROL_TYPE, null)));
	}

	@Override
	public void save(Document document, Element element, MetaRefreshState meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_TEXT, meta.getText(),null);
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), null);
		DomHelper.writeAttr(element, MetaConstants.REFRESHCONTROL_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.REFRESHCONTROL_TYPE, RefreshStateType.toString(meta.getType()), null);

	}

}
