package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.ProgressIndicatorSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;

public class MetaProgressIndicatorExtPropertiesAction extends DomPropertiesAction<MetaProgressIndicatorProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaProgressIndicatorProperties meta, int runType) {
		meta.setSourceType(ProgressIndicatorSourceType.parse(DomHelper.readAttr(element,
				MetaConstants.PROGRESSINDICATOR_SOURCETYPE, "")));
		meta.setCompletedIcon(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDICON, null));
		meta.setAttentionIcon(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_ATTENTIONICON, null));
		meta.setAttentionTextColor(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_ATTENTIONTEXTCOLOR, null));
		meta.setDefaultIcon(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_DEFAULTICON, null));
		meta.setUnCompletedLineColor(
				DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_UNCOMPLETEDLINECOLOR, null));
		meta.setUnCompletedTextColor(
				DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_UNCOMPLETEDTEXTCOLOR, null));
		meta.setCompletedLineColor(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDLINECOLOR, null));
		meta.setCompletedTextColor(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDTEXTCOLOR, null));
		meta.setOrientation(OrientationType.parse(
				DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, "")));
		meta.setReverseDraw(DomHelper.readBool(element, MetaConstants.PROGRESSINDICATOR_REVERSEDRAW, null));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_TABLEKEY, null));
		meta.setTitleColumnKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_TITLECOLUMNKEY, null));
		meta.setMessageColumnKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_MESSAGECOLUMNKEY, null));
		meta.setDateTimeColumnKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_DATETIMECOLUMNKEY, null));
		meta.setScroll(DomHelper.readBool(element, MetaConstants.PROGRESSINDICATOR_ISSCROLL, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaProgressIndicatorProperties meta, int runType) {
		// TODO Auto-generated method stub
		
	}

}
