package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FilterValueType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaFilterValueExtAction extends BaseDomAction<MetaFilterValue> {

    @Override
    public void load(Document document, Element element,
                     MetaFilterValue meta, int runType) {
        meta.setKey(DomHelper.readAttr(element,  "Index", ""));
        meta.setType(FilterValueType.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_TYPE, FilterValueType.STR_FORMULA)));
        meta.setFieldKey(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_FIELDKEY, null));
        meta.setRefValue(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_REFVALUE, null));
        meta.setParaValue(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_PARAVALUE, null));
        meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "")));
        meta.setSign(CondSign.parse(DomHelper.readAttr(element, MetaConstants.CONDITION_SIGN, "")));
    }

    @Override
    public void save(Document document, Element element,
                     MetaFilterValue meta, int runType) {
    }

}
