package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;

public class MetaToggleButtonPropertiesAction extends DomPropertiesAction<MetaToggleButtonProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaToggleButtonProperties meta, int runType) {
		meta.setTextOn(DomHelper.readAttr(element, MetaConstants.COLLAPSE_TEXTON, ""));
		meta.setTextOff(DomHelper.readAttr(element, MetaConstants.COLLAPSE_TEXTOFF, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.TOGGLEBUTTON_ICON, ""));
		meta.setIconOn(DomHelper.readAttr(element, MetaConstants.TOGGLEBUTTON_ICONON, ""));
		meta.setIconOff(DomHelper.readAttr(element, MetaConstants.TOGGLEBUTTON_ICONOFF, ""));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, IconLocationType.STR_LEFT)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaToggleButtonProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_TEXTON, meta.getTextOn(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_TEXTOFF, meta.getTextOff(), "");
		DomHelper.writeAttr(element, MetaConstants.TOGGLEBUTTON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.TOGGLEBUTTON_ICONON, meta.getIconOn(), "");
		DomHelper.writeAttr(element, MetaConstants.TOGGLEBUTTON_ICONOFF, meta.getIconOff(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
	}

}
