package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaPara;

public class MetaParaAction extends BaseDomAction<MetaPara> {

	@Override
	public void load(Document document, Element element, MetaPara meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.MAP_PARA_KEY, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.MAP_PARA_VALUE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaPara meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.MAP_PARA_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.MAP_PARA_VALUE, meta.getValue(), "");
	}

}
