package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;

public class MetaNoticeBarPropertiesAction extends DomPropertiesAction<MetaNoticeBarProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaNoticeBarProperties meta, int runType) {
		meta.setPreIcon(DomHelper.readAttr(element, MetaConstants.NOTICEBAR_PREICON, ""));
		meta.setActionIcon(DomHelper.readAttr(element, MetaConstants.NOTICEBAR_ACTIONICON, ""));
		meta.setScrollable(DomHelper.readAttr(element, MetaConstants.NOTICEBAR_SCROLLABLE, true));
		meta.setSingleLine(DomHelper.readAttr(element, MetaConstants.NOTICEBAR_SINGLELINE, true));
		meta.setOrientation(OrientationType.parse(
				DomHelper.readAttr(element, MetaConstants.NOTICEBAR_ORIENTATION, OrientationType.STR_Horizontal)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaNoticeBarProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.NOTICEBAR_PREICON, meta.getPreIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.NOTICEBAR_ACTIONICON, meta.getActionIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.NOTICEBAR_SCROLLABLE, meta.getScrollable(), true);
		DomHelper.writeAttr(element, MetaConstants.NOTICEBAR_SINGLELINE, meta.getSingleLine(), true);
		DomHelper.writeAttr(element, MetaConstants.NOTICEBAR_ORIENTATION,
				OrientationType.toString(meta.getOrientation()), OrientationType.STR_Horizontal);
	}

}
