package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FilterValueType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;

public class MetaFilterValueAction extends BaseDomAction<MetaFilterValue> {

	@Override
	public void load(Document document, Element element,
			MetaFilterValue meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, "Index", ""));
		meta.setType(FilterValueType.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_TYPE, FilterValueType.STR_FORMULA)));
		meta.setFieldKey(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_FIELDKEY, ""));
		meta.setRefValue(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_REFVALUE, ""));
		meta.setParaValue(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_PARAVALUE, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "")));
		meta.setSign(CondSign.parse(DomHelper.readAttr(element, MetaConstants.CONDITION_SIGN, CondSign.S_EQ)));
	}

	@Override
	public void save(Document document, Element element,
			MetaFilterValue meta, int runType) {
		DomHelper.writeAttr(element, "Index", meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTERVALUE_TYPE, FilterValueType.format(meta.getType()), FilterValueType.STR_FORMULA);
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTERVALUE_FIELDKEY, meta.getFieldKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTERVALUE_REFVALUE, meta.getRefValueKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTERVALUE_PARAVALUE, meta.getParaValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DATATYPE, DataType.toString(meta.getDataType()), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_SIGN, CondSign.toString(meta.getSign()), CondSign.S_EQ);
	}

}
