package com.bokesoft.yes.meta.persist.dom.form.component.control.progressindicator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressItem;

public class MetaProgressItemAction extends BaseDomAction<MetaProgressItem>{

	@Override
	public void load(Document document, Element element, MetaProgressItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setTitle(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATORITEM_TITLE, ""));
		meta.setMessage(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATORITEM_MESSAGE, ""));
		meta.setDateTime(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATORITEM_DATETIME, ""));
	}

	@Override
	public void save(Document document, Element element, MetaProgressItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATORITEM_TITLE, meta.getTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATORITEM_MESSAGE, meta.getMessage(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATORITEM_DATETIME, meta.getDateTime(), "");
	}

}
