package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewRow;

public class MetaListViewRowAction extends BaseDomAction<MetaListViewRow> {

	@Override
	public void load(Document document, Element element, MetaListViewRow meta, int runType) {
		meta.setSeparatorStyle(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORSTYLE, ""));
		meta.setSeparatorRadius(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORRADIUS, -1));
		meta.setSeparatorColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORCOLOR, ""));
		String separatorOffset = DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST, "");
		if (separatorOffset != null && !separatorOffset.isEmpty()) {
			meta.setSeparatorOffset(DefSize.parse(separatorOffset));
		}
		meta.setTopMargin(DomHelper.readAttr(element, MetaConstants.TABLEROW_TOPMARGIN, ""));
		meta.setSelectColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_SELECTCOLOR, ""));
		meta.setHighlightColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_HIGHLIGHTCOLOR, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
		meta.setRowGap(DomHelper.readAttr(element, MetaConstants.TABLEROW_ROWGAP, 0));
	}

	@Override
	public void save(Document document, Element element, MetaListViewRow meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORSTYLE, meta.getSeparatorStyle(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORRADIUS, meta.getSeparatorRadius(), -1);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORCOLOR, meta.getSeparatorColor(), "");
		DefSize separatorOffset = meta.getSeparatorOffset();
		if (separatorOffset != null) {
			DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST, separatorOffset.toString(), "");
		}else {
			DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST, (String)null, null);
		}
		
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_TOPMARGIN, meta.getTopMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SELECTCOLOR, meta.getSelectColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_HIGHLIGHTCOLOR, meta.getHighlightColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_ROWGAP, meta.getRowGap(), 0);
	}

}
