package com.bokesoft.yes.meta.persist.dom.form.component.control.dictview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumn;

public class MetaDictViewColumnAction extends BaseDomAction<MetaDictViewColumn>{

	@Override
	public void load(Document document, Element element, MetaDictViewColumn meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));		
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.DICTVIEW_COLUMN_WIDTH, "")));
	}

	@Override
	public void save(Document document, Element element, MetaDictViewColumn meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DefSize width = meta.getWidth();
		if ( width != null ) {
			DomHelper.writeAttr(element, MetaConstants.DICTVIEW_COLUMN_WIDTH, width.toString(), "");
		}
	}

}
