package com.bokesoft.yes.meta.persist.dom.form.component.control.dictview;

import com.bokesoft.yigo.common.def.DictLoadType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;

public class MetaDictViewAction extends MetaComponentAction<MetaDictView> {
	@Override
	public void load(Document document, Element element, MetaDictView meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setFormulaItemKey(DomHelper.readAttr(element, MetaConstants.DICTVIEW_FORMULAITEMKEY, ""));
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.DICTVIEW_PAGEROWCOUNT, 50));
		meta.setOnlyExpand(DomHelper.readAttr(element, MetaConstants.DICTVIEW_ONLYEXPAND, false));
		meta.setShowTitle(DomHelper.readAttr(element, MetaConstants.DICTVIEW_SHOWTITLE, true));
		meta.setLoadType(DictLoadType.parse(DomHelper.readAttr(element, MetaConstants.DICT_LOADTYPE, DictLoadType.STR_R2L)));
	}

	@Override
	public void save(Document document, Element element, MetaDictView meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.DICTVIEW_FORMULAITEMKEY, meta.getFormulaItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DICTVIEW_PAGEROWCOUNT, meta.getPageRowCount(), 50);
		DomHelper.writeAttr(element, MetaConstants.DICTVIEW_ONLYEXPAND, meta.getOnlyExpand(), false);
		DomHelper.writeAttr(element, MetaConstants.DICTVIEW_SHOWTITLE, meta.getShowTitle(), true);
		DomHelper.writeAttr(element, MetaConstants.DICT_LOADTYPE, DictLoadType.format(meta.getLoadType()), DictLoadType.STR_R2L);
	}
}
