package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.PriceLabelItemType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelItem;

public class MetaPriceLabelItemAction extends BaseDomAction<MetaPriceLabelItem> {

	@Override
	public void load(Document document, Element element, MetaPriceLabelItem meta, int runType) {
		meta.setType(PriceLabelItemType.parse(
				DomHelper.readAttr(element, MetaConstants.PRICELABEL_ITEM_TYPE, "")));
	}

	@Override
	public void save(Document document, Element element, MetaPriceLabelItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PRICELABEL_ITEM_TYPE, 
				PriceLabelItemType.toString(meta.getType()), "");
	}

}
