package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaBatchImageUploader;

public class MetaBatchImageUploaderAction extends MetaComponentAction<MetaBatchImageUploader> {
	@Override
	public void load(Document document, Element element, MetaBatchImageUploader meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setMaxSize(DomHelper.readAttr(element, MetaConstants.BATCHIMAGEUPLOADER_MAXSIZE, -1));
		meta.setMaxCount(DomHelper.readAttr(element, MetaConstants.BATCHIMAGEUPLOADER_MAXCOUNT, -1));
	}

	@Override
	public void save(Document document, Element element, MetaBatchImageUploader meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.BATCHIMAGEUPLOADER_MAXSIZE, meta.getMaxSize(), -1);
		DomHelper.writeAttr(element, MetaConstants.BATCHIMAGEUPLOADER_MAXCOUNT, meta.getMaxCount(), -1);
	}
}
