package com.bokesoft.yes.meta.persist.dom.form.component.chart;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ChartSourceType;
import com.bokesoft.yigo.common.def.ChartType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;

public class MetaChartAction extends MetaComponentAction<MetaChart> {
	@Override
	public void load(Document document, Element element, MetaChart meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setChartType(ChartType.parse(DomHelper.readAttr(element, MetaConstants.CHART_CHART_TYPE, ChartType.STR_Line)));
		meta.setSourceType(ChartSourceType.parse(DomHelper.readAttr(element, MetaConstants.CHART_SOURCE_TYPE, "")));
		meta.setTitle(DomHelper.readAttr(element, MetaConstants.CHART_TITLE, ""));
		meta.setSeriesInRow(DomHelper.readAttr(element, MetaConstants.CHART_SERIES_IN_ROW, false));
		meta.setSeriesAxisTitle(DomHelper.readAttr(element, MetaConstants.CHART_SERIES_AXIS_TITLE, ""));
		meta.setCategoryAxisTitle(DomHelper.readAttr(element, MetaConstants.CHART_CATEGORY_AXIS_TITLE, ""));
		meta.setShowValue(DomHelper.readAttr(element, MetaConstants.CHART_SHOW_VALUES, true));
		meta.setFill(DomHelper.readAttr(element, MetaConstants.CHART_FILL, false));
		meta.setHasAnimation(DomHelper.readAttr(element, MetaConstants.CHART_HAS_ANIMATION, false));
	}

	@Override
	public void save(Document document, Element element, MetaChart meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.CHART_CHART_TYPE, ChartType.toString(meta.getChartType()), ChartType.STR_Line);
		DomHelper.writeAttr(element, MetaConstants.CHART_SOURCE_TYPE, ChartSourceType.toString(meta.getSourceType()), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_TITLE, meta.getTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_SERIES_IN_ROW, meta.getSeriesInRow(), false);
		DomHelper.writeAttr(element, MetaConstants.CHART_SERIES_AXIS_TITLE, meta.getSeriesAxisTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_CATEGORY_AXIS_TITLE, meta.getCategoryAxisTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_SHOW_VALUES, meta.isShowValue(), true);
		DomHelper.writeAttr(element, MetaConstants.CHART_FILL, meta.isFill(), false);
		DomHelper.writeAttr(element, MetaConstants.CHART_HAS_ANIMATION, meta.isHasAnimation(), false);
	}
}
