package com.bokesoft.yes.meta.persist.dom.form.component.bar;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EntryItemType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.bar.MetaTreeMenuItem;

public class MetaTreeMenuItemAction extends BaseDomAction<MetaTreeMenuItem> {

	@Override
	public void load(Document document, Element element,
			MetaTreeMenuItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setType(EntryItemType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, EntryItemType.STR_Form)));
		meta.setFormKey(DomHelper.readAttr(element, MetaConstants.COMMON_FORMKEY, ""));
		meta.setURL(DomHelper.readAttr(element, MetaConstants.HYPERLINK_URL, ""));
		meta.setParameters(DomHelper.readAttr(element, MetaConstants.TREEMENUBAR_PARAMETERS, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaTreeMenuItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, EntryItemType.toString(meta.getType()), EntryItemType.STR_Form);
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.HYPERLINK_URL, meta.getURL(), "");
		DomHelper.writeAttr(element, MetaConstants.TREEMENUBAR_PARAMETERS, meta.getParameters(), "");
	}

}
