package com.bokesoft.yes.meta.persist.dom.form.component;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;

public class MetaEmbedAction extends MetaComponentAction<MetaEmbed> {
	@Override
	public void load(Document document, Element element, MetaEmbed meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setFormKey(DomHelper.readAttr(element, MetaConstants.COMMON_FORMKEY, ""));
		meta.setRootKey(DomHelper.readAttr(element, MetaConstants.EMBED_ROOTKEY, ""));
		meta.setIncludeDataTable(DomHelper.readAttr(element, MetaConstants.EMBED_INCLUDEDATATABLE, true));
	}
	
	@Override
	public void save(Document document, Element element, MetaEmbed meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.EMBED_ROOTKEY, meta.getRootKey(), "");
		DomHelper.writeAttr(element, MetaConstants.EMBED_INCLUDEDATATABLE, meta.isIncludeDataTable(), true);
	}
}
